package db

import (
	"github.com/jackc/pgx/v4/pgxpool"

	"a.yandex-team.ru/travel/avia/shared_flights/status_importer/internal/settings"
)

func NewCluster(config *settings.PG) (Cluster, error) {
	c := new(cluster)
	var err error
	c.rwConnPool, err = newConnectionPool(config.Hosts, config, true)
	if err != nil {
		return nil, err
	}
	c.anyConnPool, err = newConnectionPool(config.Hosts, config, false)
	if err != nil {
		return nil, err
	}
	return c, nil
}

type Cluster interface {
	RW() *pgxpool.Pool
	RO() *pgxpool.Pool
}

type cluster struct {
	rwConnPool  *pgxpool.Pool
	anyConnPool *pgxpool.Pool
}

func (c *cluster) RW() *pgxpool.Pool {
	return c.rwConnPool
}

func (c *cluster) RO() *pgxpool.Pool {
	return c.anyConnPool
}
