package db

import (
	"os"

	pgx "github.com/jackc/pgx/v4"
)

func logLevelFromEnvOrDefault(_default_ pgx.LogLevel) pgx.LogLevel {
	pgLogLevelStr := os.Getenv("AVIA_PG_LOG_LEVEL")
	if len(pgLogLevelStr) == 0 {
		return _default_
	}
	ll, err := pgx.LogLevelFromString(pgLogLevelStr)
	if err != nil {
		return _default_
	}
	return ll
}
