package handlers

import (
	"encoding/json"
	"fmt"
	"net/http"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/travel/avia/shared_flights/lib/go/logger"
)

type Response struct {
	Status  int
	Error   error
	Message interface{}
}

func (response *Response) error() string {
	if response.Error != nil {
		return fmt.Sprint(response.Error)
	}
	return ""
}

func (response *Response) WriteJSON(w http.ResponseWriter) {
	bytes, err := json.Marshal(struct {
		Error   string
		Message interface{}
	}{response.error(), response.Message})
	if err != nil {
		logger.Logger().Error("Cannot marshal response", log.Error(err), log.Reflect("msg", response))
		w.WriteHeader(http.StatusInternalServerError)
		w.Header().Set("Content-Type", "text/plain")
		if _, err = w.Write([]byte(fmt.Sprintf("%+v", err))); err != nil {
			logger.Logger().Error("Tried to send response, but failed", log.Error(err))
		}
		return
	}
	if response.Status > 0 {
		w.WriteHeader(response.Status)
	}
	w.Header().Set("Content-Type", "application/json")
	if _, err = w.Write(bytes); err != nil {
		logger.Logger().Error("Cannot write response", log.Error(err))
	}
}
