package handlers

import (
	"net/http"

	"a.yandex-team.ru/travel/avia/shared_flights/lib/go/logger"
	"a.yandex-team.ru/travel/avia/shared_flights/status_importer/internal/shutdown"
)

func ShutdownHandler(shutdownable shutdown.Shutdownable) http.HandlerFunc {
	return func(w http.ResponseWriter, r *http.Request) {
		logger.Logger().Info("Shutdown handler is called. Initiating shutdown sequence")
		shutdownable.Shutdown()
		logger.Logger().Info("Shutdown sequence complete")
		var response Response
		defer response.WriteJSON(w)
		response.Message = "OK"
	}
}
