package legcache

import (
	"context"
	"time"

	"a.yandex-team.ru/library/go/core/xerrors"
	"a.yandex-team.ru/travel/avia/shared_flights/status_importer/internal/objects"
	"a.yandex-team.ru/travel/avia/shared_flights/status_importer/internal/objects/cache"
)

type Config struct {
	FlightLegProvider objects.FlightLegProvider
	FlightsProvider   objects.FlightProvider
	UpdateInterval    time.Duration
	PrecacheWindow    time.Duration
}

func New(config *Config) *flightLegCache {
	c := &flightLegCache{
		config: config,
		innerCache: &innerCache{
			db:      make(map[cacheKey]cacheItem),
			overlay: make(map[cacheKey]cacheItem),
		},
	}
	if config.FlightsProvider != nil {
		cache.RunUpdater(&cache.UpdaterConfig{
			Name:          "flight leg",
			Renewer:       c.updater,
			RenewInterval: config.UpdateInterval,
			Ctx:           context.Background(),
		})
	}
	return c
}

func (c *flightLegCache) updater() error {
	newCache := &innerCache{
		db:      make(map[cacheKey]cacheItem),
		overlay: make(map[cacheKey]cacheItem),
	}
	if err := newCache.loadFlightsInDateWindow(c.config.PrecacheWindow, c.config.FlightsProvider); err != nil {
		return xerrors.Errorf("flight leg cache updater: %w", err)
	}

	newCache.copyOverlayDeleteOld(c.innerCache)

	c.innerCache = newCache
	return nil
}
