package statussrccache

import (
	"context"
	"time"

	"a.yandex-team.ru/library/go/core/xerrors"
	"a.yandex-team.ru/travel/avia/shared_flights/status_importer/internal/objects/cache"
	"a.yandex-team.ru/travel/avia/shared_flights/status_importer/internal/objects/model"
)

type StatusSource struct {
	*statusSourceCache

	config *Config
}

type statusSourceCache struct {
	byName map[string]*model.StatusSource
}

type StatusSourceProvider interface {
	All() (chan *model.StatusSource, error)
}

type Config struct {
	StatusSourceProvider StatusSourceProvider
	UpdateInterval       time.Duration
}

func New(config *Config) *StatusSource {
	c := &StatusSource{
		config: config,
	}
	cache.RunUpdater(&cache.UpdaterConfig{
		Name:          "status-source",
		Renewer:       c.updater,
		RenewInterval: config.UpdateInterval,
		Ctx:           context.Background(),
	})
	return c
}

func (c *StatusSource) updater() error {
	statusSourceChan, err := c.config.StatusSourceProvider.All()
	if err != nil {
		return xerrors.Errorf("status source cache updater: %w", err)
	}
	newCache := &statusSourceCache{
		make(map[string]*model.StatusSource),
	}
	for source := range statusSourceChan {
		if len(source.Name) > 0 {
			newCache.byName[source.Name] = source
		}
	}
	c.statusSourceCache = newCache
	return nil
}

func (c *statusSourceCache) ByName(name string) *model.StatusSource {
	v, ok := c.byName[name]
	if !ok {
		return nil
	}
	return v
}
