package combined

import (
	"a.yandex-team.ru/travel/avia/shared_flights/status_importer/internal/objects"
	"a.yandex-team.ru/travel/avia/shared_flights/status_importer/internal/objects/combined/carrier"
	leg "a.yandex-team.ru/travel/avia/shared_flights/status_importer/internal/objects/combined/flight-leg"
	"a.yandex-team.ru/travel/avia/shared_flights/status_importer/internal/objects/combined/station"
	statusSource "a.yandex-team.ru/travel/avia/shared_flights/status_importer/internal/objects/combined/status-source"
	stopPoint "a.yandex-team.ru/travel/avia/shared_flights/status_importer/internal/objects/combined/stop-point"
)

func New(config objects.Config) *objects.Objects {
	return &objects.Objects{
		Carrier: carrier.New(&carrier.Config{
			Cluster:        config.Cluster,
			UpdateInterval: config.UpdateInterval,
		}),
		FlightLeg: leg.New(&leg.Config{
			Cluster:        config.Cluster,
			UpdateInterval: config.UpdateInterval,
			PrecacheWindow: config.PrecacheWindow,
		}),
		Station: station.New(&station.Config{
			Cluster:        config.Cluster,
			UpdateInterval: config.UpdateInterval,
		}),
		StatusSource: statusSource.New(&statusSource.Config{
			Cluster:        config.Cluster,
			UpdateInterval: config.UpdateInterval,
		}),
		StopPoint: stopPoint.New(&stopPoint.Config{
			Cluster:        config.Cluster,
			UpdateInterval: config.UpdateInterval,
		}),
	}
}
