package carrier

import (
	"time"

	"a.yandex-team.ru/travel/avia/shared_flights/status_importer/internal/db"
	"a.yandex-team.ru/travel/avia/shared_flights/status_importer/internal/objects"
	carriercache "a.yandex-team.ru/travel/avia/shared_flights/status_importer/internal/objects/cache/carrier"
	carrierdb "a.yandex-team.ru/travel/avia/shared_flights/status_importer/internal/objects/db/carrier"
)

type Config struct {
	Cluster        db.Cluster
	UpdateInterval time.Duration
}

func New(config *Config) objects.Carrier {
	carrierDB := carrierdb.New(config.Cluster)
	stationCache := carriercache.New(&carriercache.Config{
		CarrierProvider: carrierDB,
		UpdateInterval:  config.UpdateInterval,
	})
	return stationCache
}
