package leg

import (
	"time"

	"a.yandex-team.ru/travel/avia/shared_flights/status_importer/internal/db"
	"a.yandex-team.ru/travel/avia/shared_flights/status_importer/internal/objects"
	legcache "a.yandex-team.ru/travel/avia/shared_flights/status_importer/internal/objects/cache/flight-leg"
	legdb "a.yandex-team.ru/travel/avia/shared_flights/status_importer/internal/objects/db/flight-leg"
)

type Config struct {
	Cluster        db.Cluster
	UpdateInterval time.Duration
	PrecacheWindow time.Duration
}

func New(config *Config) objects.FlightLegProvider {
	dbLeg := legdb.New(config.Cluster)
	stationCache := legcache.New(&legcache.Config{
		FlightLegProvider: &dbLeg,
		FlightsProvider:   &dbLeg,
		UpdateInterval:    config.UpdateInterval,
		PrecacheWindow:    config.PrecacheWindow,
	})
	return stationCache
}
