package station

import (
	"time"

	"a.yandex-team.ru/travel/avia/shared_flights/status_importer/internal/db"
	"a.yandex-team.ru/travel/avia/shared_flights/status_importer/internal/objects"
	stationcache "a.yandex-team.ru/travel/avia/shared_flights/status_importer/internal/objects/cache/station"
	stationdb "a.yandex-team.ru/travel/avia/shared_flights/status_importer/internal/objects/db/station"
)

type Config struct {
	Cluster        db.Cluster
	UpdateInterval time.Duration
}

func New(config *Config) objects.Station {
	stationDB := stationdb.New(config.Cluster)
	stationCache := stationcache.New(&stationcache.Config{
		StationProvider: stationDB,
		UpdateInterval:  config.UpdateInterval,
	})
	return stationCache
}
