package statussrc

import (
	"time"

	"a.yandex-team.ru/travel/avia/shared_flights/status_importer/internal/db"
	"a.yandex-team.ru/travel/avia/shared_flights/status_importer/internal/objects"
	statussrccache "a.yandex-team.ru/travel/avia/shared_flights/status_importer/internal/objects/cache/status-source"
	statussrcdb "a.yandex-team.ru/travel/avia/shared_flights/status_importer/internal/objects/db/status-source"
)

type Config struct {
	Cluster        db.Cluster
	UpdateInterval time.Duration
}

func New(config *Config) objects.StatusSource {
	ssDB := statussrcdb.New(config.Cluster)
	ssCache := statussrccache.New(&statussrccache.Config{
		StatusSourceProvider: &ssDB,
		UpdateInterval:       config.UpdateInterval,
	})
	return ssCache
}
