package stoppoint

import (
	"time"

	"a.yandex-team.ru/travel/avia/shared_flights/status_importer/internal/db"
	"a.yandex-team.ru/travel/avia/shared_flights/status_importer/internal/objects"
	stoppointcache "a.yandex-team.ru/travel/avia/shared_flights/status_importer/internal/objects/cache/stop-point"
	stoppointdb "a.yandex-team.ru/travel/avia/shared_flights/status_importer/internal/objects/db/stop-point"
)

type Config struct {
	Cluster        db.Cluster
	UpdateInterval time.Duration
}

func New(config *Config) objects.StopPoint {
	stopPointDB := stoppointdb.New(config.Cluster)
	stopPointCache := stoppointcache.New(&stoppointcache.Config{
		StopPointProvider: stopPointDB,
		UpdateInterval:    config.UpdateInterval,
	})
	return stopPointCache
}
