package objects

import (
	"time"

	"a.yandex-team.ru/travel/avia/shared_flights/lib/go/direction"
	"a.yandex-team.ru/travel/avia/shared_flights/lib/go/dtutil"
	"a.yandex-team.ru/travel/avia/shared_flights/status_importer/internal/objects/model"
)

// Objects entry point struct to access data
type Objects struct {
	Carrier      Carrier
	FlightLeg    FlightLegProvider
	Station      Station
	StatusSource StatusSource
	StopPoint    StopPoint
}

type Carrier interface {
	ByID(id int64) model.Carrier
	ByCode(code string) []model.Carrier
}

type Station interface {
	ByCode(code string) *model.Station
	ByID(id model.StationID) *model.Station
}

type StatusSource interface {
	ByName(name string) *model.StatusSource
}

type StopPoint interface {
	ByCode(code string) *model.StopPoint
}

type FlightLegProvider interface {
	FlightLeg(carrierID int64, flightNumber string, flightDay dtutil.StringDate, direction direction.Direction, stationID model.StationID) (leg int16, departureDate dtutil.StringDate, err error)
}

type FlightProvider interface {
	Flights(
		dest chan *model.FlightPatternRecord,
		from time.Time,
		to time.Time,
	) error
}
