package carrierdb

import (
	"context"
	"time"

	pgx "github.com/jackc/pgx/v4"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/travel/avia/shared_flights/lib/go/logger"
	"a.yandex-team.ru/travel/avia/shared_flights/status_importer/internal/db"
	"a.yandex-team.ru/travel/avia/shared_flights/status_importer/internal/objects/model"
)

type Carrier struct {
	cluster db.Cluster
}

func New(cluster db.Cluster) *Carrier {
	return &Carrier{cluster: cluster}
}

func (s *Carrier) All() (chan *model.Carrier, error) {
	pool := s.cluster.RO()
	ctx, cancel := context.WithTimeout(context.Background(), time.Minute)
	conn, poolError := pool.Acquire(ctx)
	if poolError != nil {
		cancel()
		logger.Logger().Error("unable to get a connection", log.Error(poolError))
		return nil, poolError
	}

	carriers := make(chan *model.Carrier)
	go func() {
		defer cancel()
		defer conn.Release()
		defer close(carriers)

		var (
			tx  pgx.Tx
			err error
		)
		if tx, err = conn.Begin(ctx); err != nil {
			logger.Logger().Error("cannot begin transaction", log.Error(err))
			return
		}

		var rows pgx.Rows
		rows, err = tx.Query(
			ctx,
			`SELECT id, iata, sirena_id, icao, icao_ru, priority FROM carrier WHERE not is_hidden`)
		if err != nil {
			logger.Logger().Error("Cannot read carriers from database", log.Error(err))
		}
		defer rows.Close()
		cnt := 0
		for rows.Next() {
			cnt++
			carrier := new(model.Carrier)
			err = rows.Scan(
				&carrier.ID,
				&carrier.Iata,
				&carrier.Sirena,
				&carrier.Icao,
				&carrier.IcaoRU,
				&carrier.Priority,
			)
			if err != nil {
				logger.Logger().Error("Cannot read carriers from database", log.Error(err))
				continue
			}
			carriers <- carrier
		}
	}()

	return carriers, nil
}
