package stationdb

import (
	"context"
	"time"

	pgx "github.com/jackc/pgx/v4"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/travel/avia/shared_flights/lib/go/logger"
	"a.yandex-team.ru/travel/avia/shared_flights/status_importer/internal/db"
	"a.yandex-team.ru/travel/avia/shared_flights/status_importer/internal/objects/model"
)

type Station struct {
	cluster db.Cluster
}

func New(cluster db.Cluster) *Station {
	return &Station{cluster: cluster}
}

func (s *Station) All() (chan *model.Station, error) {
	pool := s.cluster.RO()
	ctx, cancel := context.WithTimeout(context.Background(), time.Minute)
	conn, poolError := pool.Acquire(ctx)
	if poolError != nil {
		cancel()
		return nil, poolError
	}
	stations := make(chan *model.Station)
	go func() {
		defer cancel()
		defer conn.Release()
		defer close(stations)

		var (
			tx  pgx.Tx
			err error
		)
		if tx, err = conn.Begin(ctx); err != nil {
			logger.Logger().Error("cannot begin transaction", log.Error(err))
			return
		}

		var rows pgx.Rows
		rows, err = tx.Query(ctx, `SELECT id, iata, sirena FROM station_with_codes`)
		if err != nil {
			logger.Logger().Error(
				"Cannot read stations from database",
				log.Error(err),
			)
		}
		defer rows.Close()
		for rows.Next() {
			station := new(model.Station)
			err = rows.Scan(
				&station.ID,
				&station.Iata,
				&station.Sirena,
			)
			if err != nil {
				logger.Logger().Error(
					"Cannot read stations from database",
					log.Error(err),
				)
				continue
			}
			stations <- station
		}
	}()

	return stations, nil
}
