package statussrcdb

import (
	"context"
	"time"

	pgx "github.com/jackc/pgx/v4"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/travel/avia/shared_flights/lib/go/logger"
	"a.yandex-team.ru/travel/avia/shared_flights/status_importer/internal/db"
	"a.yandex-team.ru/travel/avia/shared_flights/status_importer/internal/objects/model"
)

type StatusSource struct {
	cluster db.Cluster
}

func New(cluster db.Cluster) StatusSource {
	return StatusSource{cluster: cluster}
}

func (ss *StatusSource) All() (chan *model.StatusSource, error) {
	pool := ss.cluster.RO()
	ctx, cancel := context.WithTimeout(context.Background(), time.Minute)
	conn, poolError := pool.Acquire(ctx)
	if poolError != nil {
		cancel()
		return nil, poolError
	}
	statusSourcesChan := make(chan *model.StatusSource)
	go func() {
		defer cancel()
		defer conn.Release()
		defer close(statusSourcesChan)

		var (
			tx  pgx.Tx
			err error
		)
		if tx, err = conn.Begin(ctx); err != nil {
			logger.Logger().Error("cannot begin transaction", log.Error(err))
			return
		}

		var rows pgx.Rows
		rows, err = tx.Query(ctx, `SELECT id, name, priority FROM status_source`)
		if err != nil {
			logger.Logger().Error(
				"Cannot read status sources from database",
				log.Error(err),
			)
			return
		}
		defer rows.Close()
		for rows.Next() {
			statusSourceInst := new(model.StatusSource)
			err = rows.Scan(
				&statusSourceInst.ID,
				&statusSourceInst.Name,
				&statusSourceInst.Priority,
			)
			if err != nil {
				logger.Logger().Error(
					"Cannot read status sources from database",
					log.Error(err),
				)
				continue
			}
			logger.Logger().Info("Status source",
				log.Int16("id", statusSourceInst.ID),
				log.String("Name", statusSourceInst.Name),
				log.Int16("id", statusSourceInst.Priority),
			)
			statusSourcesChan <- statusSourceInst
		}
	}()
	return statusSourcesChan, nil
}
