package stoppointdb

import (
	"context"
	"time"

	pgx "github.com/jackc/pgx/v4"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/travel/avia/shared_flights/lib/go/logger"
	"a.yandex-team.ru/travel/avia/shared_flights/status_importer/internal/db"
	"a.yandex-team.ru/travel/avia/shared_flights/status_importer/internal/objects/model"
)

type StopPoint struct {
	cluster db.Cluster
}

func New(cluster db.Cluster) *StopPoint {
	return &StopPoint{cluster: cluster}
}

func (s *StopPoint) All() (chan *model.StopPoint, error) {
	pool := s.cluster.RO()
	ctx, cancel := context.WithTimeout(context.Background(), time.Minute)
	conn, poolError := pool.Acquire(ctx)
	if poolError != nil {
		cancel()
		return nil, poolError
	}
	stopPoints := make(chan *model.StopPoint)
	go func() {
		defer cancel()
		defer conn.Release()
		defer close(stopPoints)

		var (
			tx  pgx.Tx
			err error
		)
		if tx, err = conn.Begin(ctx); err != nil {
			logger.Logger().Error("cannot begin transaction", log.Error(err))
			return
		}

		var rows pgx.Rows
		rows, err = tx.Query(context.Background(), `SELECT station_code, station_id, city_code FROM stop_point`)
		if err != nil {
			logger.Logger().Error(
				"Cannot read stop points from database",
				log.Error(err),
			)
		}
		defer rows.Close()
		for rows.Next() {
			stopPoint := new(model.StopPoint)
			var cityCode *string
			var stationID *int32
			var stationCode *string
			err = rows.Scan(
				&stationCode,
				&stationID,
				&cityCode,
			)
			if stationID == nil {
				continue
			}
			stopPoint.StationID = *stationID
			if stationCode != nil {
				stopPoint.StationCode = *stationCode
			}

			if cityCode != nil {
				stopPoint.CityCode = *cityCode
			}
			if err != nil {
				logger.Logger().Error(
					"Cannot read stop points from database",
					log.Error(err),
				)
				continue
			}
			stopPoints <- stopPoint
		}
	}()

	return stopPoints, nil
}
