package model

import (
	"time"

	"a.yandex-team.ru/travel/avia/shared_flights/lib/go/dtutil"
)

type DepartureDate string

type FlightPatternKey struct {
	CarrierID       int64
	Number          string
	OperatingFrom   time.Time
	OperatingUntil  time.Time
	OperatingOnDays dtutil.OperatingDays
	ArrivalDayShift int
}

type FlightPatternRecord struct {
	FlightPatternKey
	LegNumber        int16
	DepartureStation StationID
	ArrivalStation   StationID
}

func (k *FlightPatternKey) IsOperatingAt(dt time.Time) bool {

	if dt.Before(k.OperatingFrom) {
		return false
	}
	if dt.After(k.OperatingUntil) {
		return false
	}
	if !k.OperatingOnDays.OperatesOn(dt.Weekday()) {
		return false
	}
	return true
}
