package settings

import (
	"path"

	"a.yandex-team.ru/library/go/core/log"
	aviaLogging "a.yandex-team.ru/travel/avia/library/go/logging"
)

type Logging struct {
	LogLevel       string `config:"AVIA_SF_LOG_LEVEL"`
	LogPath        string `config:"AVIA_SF_LOG_PATH"`
	SentryDSN      string `config:"AVIA_SF_SENTRY_DSN"`
	AppLogFileName string `config:"AVIA_SF_LOG_FILE_NAME"`
}

func (l *Logging) ToLoggerConfig() (*aviaLogging.Config, error) {
	level, err := log.ParseLevel(l.LogLevel)
	if err != nil {
		return nil, err
	}
	var sentryConfig *aviaLogging.SentryLoggingConfig
	if l.SentryDSN != "" {
		sentryConfig = &aviaLogging.SentryLoggingConfig{DSN: l.SentryDSN}
	}
	var fileConfig *aviaLogging.FileLoggingConfig
	if l.LogPath != "" && l.AppLogFileName != "" {
		fileConfig = &aviaLogging.FileLoggingConfig{FilePath: path.Join(l.LogPath, l.AppLogFileName)}
	}
	return &aviaLogging.Config{
		Level:               level,
		StdoutLoggingConfig: &aviaLogging.StdoutLoggingConfig{},
		FileLoggingConfig:   fileConfig,
		SentryLoggingConfig: sentryConfig,
	}, nil
}

type YtLogging struct {
	YtLogPath               string `config:"AVIA_SF_YT_LOG_PATH"`                // Путь до логов, читаемых push-клиентом
	UpdateStatusLogName     string `config:"AVIA_SF_UPDATE_STATUS_LOG_NAME"`     // Название лога для обновления статусов
	UpdateStatusLogDisabled bool   `config:"AVIA_SF_UPDATE_STATUS_LOG_DISABLED"` // Отключает запись логов обновления в файл
}
