package shutdown

import (
	"sync"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/travel/avia/shared_flights/lib/go/logger"
)

type Shutdownable interface {
	Shutdown()
}

type ShutdownRegistrar interface {
	AddShutdownable(Shutdownable)
}

type ShutdownFunc func()

func (sf ShutdownFunc) Shutdown() {
	sf()
}

type ShutdownState int

const (
	Alive = iota
	ShuttingDown
	ShutdownComplete
)

type EventDispatcher struct {
	sync.Mutex
	eventSubscribers []Shutdownable
	state            ShutdownState
}

func (ed *EventDispatcher) AddShutdownable(shutdownable Shutdownable) {
	ed.eventSubscribers = append(ed.eventSubscribers, shutdownable)
}

func (ed *EventDispatcher) Shutdown() {
	ed.Lock()
	if ed.state != Alive {
		ed.Unlock()
		logger.Logger().Info("Shutdown no-op")
		return
	}
	ed.state = ShuttingDown
	ed.Unlock()
	logger.Logger().Info("Shutdown initiated")
	for i, subscriber := range ed.eventSubscribers {
		logger.Logger().Info("Shutting down", log.Int("subscriberNumber", i))
		subscriber.Shutdown()
		logger.Logger().Info("Shutting down", log.Int("subscriberNumber", i))
	}
	ed.Lock()
	ed.state = ShutdownComplete
	ed.Unlock()
}
