package status

import (
	"strconv"
	"strings"

	"a.yandex-team.ru/library/go/core/xerrors"
)

type errorGroup []error

func (eg errorGroup) Error() string {
	errorGroups := make(map[string]int)
	for _, err := range eg {
		errorGroups[err.Error()] = errorGroups[err.Error()] + 1
	}
	builder := strings.Builder{}
	for k, v := range errorGroups {
		builder.WriteString(strconv.Itoa(v) + " of " + k + ";\n")
	}
	return builder.String()
}

// Errors implement zap errorGroup
func (eg errorGroup) Errors() []error {
	return eg
}

func (eg errorGroup) As(i interface{}) bool {
	for _, e := range eg {
		if xerrors.As(e, i) {
			return true
		}
	}
	return false
}

func (eg errorGroup) Is(target error) bool {
	for _, e := range eg {
		if xerrors.Is(e, target) {
			return true
		}
	}
	return false
}

func errOrGroup(current, new error) error {
	if current == nil {
		return new
	}
	if new == nil {
		return current
	}
	switch t := current.(type) {
	case errorGroup:
		return append(t, new)
	default:
		return errorGroup{current, new}
	}
}
