package status

import (
	"fmt"

	"a.yandex-team.ru/library/go/core/xerrors"
)

type unknownStatusSourceError struct {
	SourceName string
}

func (ss unknownStatusSourceError) Error() string {
	return fmt.Sprintf("unknown status source: %s", ss.SourceName)
}

type unknownAirportCodeError struct {
	StationCode string
}

func (s unknownAirportCodeError) Error() string {
	return fmt.Sprintf("no station for airport code: %s", s.StationCode)
}

type unknownCarrierError struct {
	CarrierID int
}

func (c unknownCarrierError) Error() string {
	return fmt.Sprintf("unknown carrier ID: %d", c.CarrierID)
}

var errNoStatuses = xerrors.New("no statuses")

type NotImportantError struct {
	error
}
