package status

import "time"

var outputLayout = "2006-01-02T15:04:05"
var possibleLayouts = [...]string{
	outputLayout,
	time.RFC3339,     // = "2006-01-02T15:04:05Z07:00"
	time.RFC3339Nano, // = "2006-01-02T15:04:05.999999999Z07:00"
	"2006-01-02T15:04:05",
	"2006-01-02T15:04",
	"2006-01-02 15:04:05Z07:00",
	"2006-01-02 15:04:05",
	"2006-01-02 15:04",
	time.ANSIC,      // = "Mon Jan _2 15:04:05 2006"
	time.UnixDate,   // = "Mon Jan _2 15:04:05 MST 2006"
	time.RubyDate,   // = "Mon Jan 02 15:04:05 -0700 2006"
	time.RFC822,     // = "02 Jan 06 15:04 MST"
	time.RFC822Z,    // = "02 Jan 06 15:04 -0700" // RFC822 with numeric zone
	time.RFC850,     // = "Monday, 02-Jan-06 15:04:05 MST"
	time.RFC1123,    // = "Mon, 02 Jan 2006 15:04:05 MST"
	time.RFC1123Z,   // = "Mon, 02 Jan 2006 15:04:05 -0700" // RFC1123 with numeric zone
	time.Kitchen,    // = "3:04PM"
	time.Stamp,      // = "Jan _2 15:04:05"
	time.StampMilli, // = "Jan _2 15:04:05.000"
	time.StampMicro, // = "Jan _2 15:04:05.000000"
	time.StampNano,  // = "Jan _2 15:04:05.000000000"
}

func normalizeTimeString(t string) (string, error) {
	if t == "" {
		return "", nil
	}
	dt, err := tryParse(t)
	if err != nil {
		return "", err
	}
	res := dt.Format(outputLayout)
	return res, nil
}

func tryParse(ts string) (time.Time, error) {
	var t time.Time
	var err error
	for _, layout := range possibleLayouts {
		t, err = time.Parse(layout, ts)
		if err == nil {
			return t, nil
		}
	}
	return t, err
}
