package storage

import (
	"fmt"
	"net/http"

	"github.com/go-chi/chi/v5"
	"github.com/go-chi/chi/v5/middleware"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/travel/avia/shared_flights/lib/go/logger"
	"a.yandex-team.ru/travel/avia/shared_flights/status_importer/internal/handlers"
	"a.yandex-team.ru/travel/avia/shared_flights/status_importer/internal/shutdown"
)

func (s *storage) RunServer(shutdownEventDispatcher *shutdown.EventDispatcher) {
	router := chi.NewRouter()

	pingHandler := handlers.NewPingHandler(
		handlers.PingHandlerConfig{
			Cluster:           s.PGCluster,
			ShutdownRegistrar: shutdownEventDispatcher,
		},
	)
	router.Get("/ping", pingHandler.ServeHTTP)

	router.Post("/shutdown", handlers.ShutdownHandler(shutdownEventDispatcher))

	statusHandler := handlers.NewStatusHandler(&handlers.StatusHandlerConfig{
		Updater: s.statusUpdater,
	})
	router.Put("/update/status", statusHandler.UpdateStatus)

	router.Mount("/debug", middleware.Profiler())

	logger.Logger().Info("Starting server", log.Int("port", s.Conf.Server.ListenPort))
	logger.Logger().Fatal("Server error",
		log.Error(
			http.ListenAndServe(
				fmt.Sprintf(":%d", s.Conf.Server.ListenPort),
				router,
			),
		),
	)

}
