package updatestatuslog

import "encoding/json"

type RESULT string

const (
	Error               = "error"
	InvalidStatus       = "invalid-status"
	AbnormalStatus      = "abnormal-status"
	UnknownStatusSource = "unknown-status-source"
	IgnoredByUpdatedAt  = "ignored-by-updated-at"
	Success             = "success"
)

type Record struct {
	Unixtime            int64  `json:"unixtime"`
	ReceivedAt          string `json:"received_at"`
	AirportCode         string `json:"airport"`
	AirlineID           int64  `json:"airline_id"`
	AirlineCode         string `json:"airline_code"`
	FlightNumber        string `json:"flight_number"`
	FlightDate          string `json:"flight_date"`
	Direction           string `json:"direction"`
	TimeActual          string `json:"time_actual"`
	TimeScheduled       string `json:"time_scheduled"`
	Status              string `json:"status"`
	Gate                string `json:"gate"`
	Terminal            string `json:"terminal"`
	CheckInDesks        string `json:"check_in_desks"`
	BaggageCarousels    string `json:"baggage_carousels"`
	Source              string `json:"source"`
	Result              string `json:"result"`
	Diverted            bool   `json:"diverted"`
	DivertedAirportCode string `json:"diverted_airport_iata"`

	MessageID string `json:"message_id"`
	StatusID  string `json:"status_id"`
}

func (r Record) JSON() ([]byte, error) {
	return json.Marshal(r)
}
