import argparse
import logging

from travel.avia.shared_flights.tasks.amadeus_parser.amadeus_fetcher import AmadeusFetcher

logging.basicConfig(
    format='%(asctime)s %(levelname)-8s %(message)s',
    level=logging.DEBUG,
    datefmt='%Y-%m-%d %H:%M:%S')
logger = logging.getLogger(__name__)


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--hostname', required=True)
    parser.add_argument('--username', required=True)
    parser.add_argument('--password', required=True)
    parser.add_argument('--last_parsed', required=True)
    _args = vars(parser.parse_args())

    amadeus_fetcher = AmadeusFetcher(
        hostname=_args['hostname'],
        username=_args['username'],
        password=_args['password'],
        logger=logger,
    )
    result = amadeus_fetcher.fetch(_args['last_parsed'])

    logger.info('Amadeus data date: {}'.format(result.data_file_timestamp))
    logger.info('Flight bases file: {}'.format(result.flight_bases_file))
    logger.info('Flight patterns file: {}'.format(result.flight_patterns_file))
    logger.info('Codeshares file: {}'.format(result.codeshares_file))
    logger.info('Done with Amadeus data fetching.')


if __name__ == '__main__':
    main()
