import argparse
import logging

from travel.avia.shared_flights.tasks.amadeus_parser.flights_parser import AmadeusFlightsParser

logging.basicConfig(
    format='%(asctime)s %(levelname)-8s %(message)s',
    level=logging.DEBUG,
    datefmt='%Y-%m-%d %H:%M:%S')
logger = logging.getLogger(__name__)


# Sample run:
# bin-parse/amadeus-parser --infile amadeus.csv
# Output is printed into three files:
# file_bases.txt - list of file bases
# file_patterns.txt - list of file patterns
# codeshares.txt - list of codeshares
def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--infile', required=True)
    parser.add_argument('--out_fb', required=False, default="flight_bases.txt")
    parser.add_argument('--out_fp', required=False, default="flight_patterns.txt")
    parser.add_argument('--out_codeshares', required=False, default="codeshares.txt")
    _args = vars(parser.parse_args())

    infile = _args['infile']
    flight_bases_file = _args['out_fb']
    flight_patterns_file = _args['out_fp']
    codeshares_file = _args['out_codeshares']

    logger.info('Initializing flights parser')
    flights_parser = AmadeusFlightsParser(logger)
    flights_parser.parse_flights_csv(infile)

    # store results
    with open(flight_bases_file, 'wt') as fb_file, open(flight_patterns_file, 'wt') as fp_file, open(codeshares_file, 'wt') as cs_file:
        flights_parser.list_flights(
            on_flight_base=lambda fb: fb_file.write('{}\n'.format(fb)),
            on_flight_pattern=lambda fp: fp_file.write('{}\n'.format(fp)),
            on_codeshare=lambda cs: cs_file.write('{}\n'.format(cs)),
        )

    logger.info('Done')


if __name__ == '__main__':
    main()
