# coding=utf-8
from __future__ import unicode_literals

import six
from collections import defaultdict, namedtuple

import travel.proto.shared_flights.ssim.flights_pb2 as flights_pb2


CodeshareKey = namedtuple(
    'CodeshareKey',
    [
        'marketing_carrier_code',
        'marketing_flight_number',
        'marketing_leg_number',
        'operating_carrier_code',
        'operating_flight_number',
        'operating_leg_number',
    ]
)


DateRange = namedtuple(
    'DateRange',
    [
        'from_date',
        'until_date',
    ]
)


# Caches codeshare info from the Amadeus file.
class CodesharesMap:

    def __init__(self):
        self.codeshares = defaultdict(list)

    def add_codeshare(
        self,
        marketing_carrier_code,
        marketing_flight_number,
        marketing_leg_number,
        operating_carrier_code,
        operating_flight_number,
        operating_leg_number,
        from_date,
        until_date,
    ):
        self.codeshares[CodeshareKey(
            marketing_carrier_code,
            marketing_flight_number,
            marketing_leg_number,
            operating_carrier_code,
            operating_flight_number,
            operating_leg_number,
        )].append(DateRange(from_date, until_date))

    def protos(self):
        for key, value_list in six.iteritems(self.codeshares):
            date_range0 = value_list[0]
            min_from = date_range0.from_date
            max_until = date_range0.until_date
            for date_range in value_list:
                if date_range.from_date < min_from:
                    min_from = date_range.from_date
                if date_range.until_date > max_until:
                    max_until = date_range.until_date
            codeshare = flights_pb2.TSsimCodeshare()
            codeshare.MarketingCarrierCode = key.marketing_carrier_code
            codeshare.MarketingFlightNumber = key.marketing_flight_number
            codeshare.MarketingLegNumber = key.marketing_leg_number
            codeshare.OperatingCarrierCode = key.operating_carrier_code
            codeshare.OperatingFlightNumber = key.operating_flight_number
            codeshare.OperatingLegNumber = key.operating_leg_number
            codeshare.FromDate = min_from
            codeshare.UntilDate = max_until
            yield codeshare
