# coding=utf-8
from __future__ import unicode_literals

from collections import namedtuple


FlightSegmentKey = namedtuple('FlightSegmentKey', ['carrier', 'flight_number', 'arrival_date', 'leg_number'])


class FlightArrivalTimesCacher(object):
    """ Caches the arrival time for the flight segments """

    def __init__(self):
        self._arrival_times = {}

    def cache_arrival_time(self, flight_segment):
        if self._is_missing_key_field(flight_segment) or flight_segment.stops != '0':
            return
        leg_number = flight_segment.get_leg_number()
        if not leg_number:
            return
        key = FlightSegmentKey(
            flight_segment.operating_carrier,
            flight_segment.operating_flight_code,
            flight_segment.arrival_date,
            leg_number,
        )
        value = self._get_arrival_time_int(flight_segment)
        if value >= 0:
            self._arrival_times[key] = value

    def get_arrival(self, operating_carrier, flight_number, arrival_date, leg_number):
        key = FlightSegmentKey(operating_carrier, flight_number, arrival_date, leg_number)
        return self._arrival_times.get(key, -1)

    def _is_missing_key_field(self, fs):
        return not fs.operating_carrier or not fs.operating_flight_code or not fs.arrival_date or not fs.leg_sequence_number

    def _get_arrival_time_int(self, fs):
        try:
            return int(fs.arrival_time)
        except:
            return -1
