# coding=utf-8
from __future__ import unicode_literals

from collections import defaultdict

from travel.avia.shared_flights.lib.python.date_utils.date_mask import DateMaskMatcher


class FlightDatesManager(object):

    def __init__(self, dmm):
        # type: (DateMaskMatcher) -> None
        self._dmm = dmm

    def new_flight_dates(self):
        return FlightDates(self._dmm)

    def add_operating_day(self, flight_dates, str_date):
        self._dmm.add_date_str(str_date, flight_dates.operating_mask)

    def add_codeshare_day(self, flight_dates, flight_title, str_date):
        self._dmm.add_date_str(str_date, flight_dates.codeshares[flight_title])


class FlightDates(object):

    def __init__(self, dmm):
        self.operating_mask = dmm.new_date_mask()
        self.codeshares = defaultdict(lambda: dmm.new_date_mask())
