import argparse
import logging

from travel.avia.shared_flights.tasks.flying_time.flying_time import FlyingTimeTool

logging.basicConfig(format='%(asctime)s %(levelname)-8s %(message)s', level=logging.DEBUG, datefmt='%Y-%m-%d %H:%M:%S')
logger = logging.getLogger(__name__)


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--environment', required=False, default='production')
    parser.add_argument('--records_limit', required=False, default=0)
    parser.add_argument('--output_mode', required=True, default='binary')
    parser.add_argument('--output_file', required=False)
    _args = parser.parse_args()

    flying_time_tool = FlyingTimeTool(
        _args.environment,
        _args.output_mode,
        _args.output_file,
        int(_args.records_limit),
    )
    flying_time_tool.run()
    logger.info('Done with Flying Time tool.')


if __name__ == '__main__':
    main()
