import argparse
import logging

from travel.avia.shared_flights.tasks.monitoring.db import collect_and_send
from travel.avia.shared_flights.tasks.monitoring.helpers import UnsupportedEnvironmentError
from travel.avia.shared_flights.tasks.monitoring.helpers import pg_cluster_session
from travel.avia.shared_flights.tasks.monitoring.helpers import solomon_push_reporter_maker

logger = logging.getLogger(__name__)


def main():
    logging.basicConfig(level=logging.INFO)

    parser = argparse.ArgumentParser()

    parser.add_argument(
        'environment', help='Environment type',
        choices=('production', 'testing', 'unstable', 'development'),
    )
    parser.add_argument('password', help='Database password')
    parser.add_argument('solomon_token', help='Solomon token with write permissions to send metrics')
    parser.add_argument('--echo', action='store_true', default=False, help='Echo sql requests')
    parser.add_argument('--debug', action='store_true', default=False, help='Use debug logging level')

    args = parser.parse_args()

    if args.debug:
        logging.basicConfig(level=logging.DEBUG)

    try:
        session_factory = pg_cluster_session(args.environment, args.password, args.echo)
        solomon_push_api = solomon_push_reporter_maker(args.environment, args.solomon_token)
        collect_and_send(session_factory, solomon_push_api)
    except UnsupportedEnvironmentError:
        logger.warning(
            'Sending metrics is not supported for %s environment',
            args.environment,
        )
    except:
        logger.exception('Unexpected error while sending metrics to solomon')


if __name__ == '__main__':
    main()
