import argparse
import logging

from travel.avia.shared_flights.tasks.quality_tool.quality_tool import QualityTool

logging.basicConfig(
    format='%(asctime)s %(levelname)-8s %(message)s',
    level=logging.DEBUG,
    datefmt='%Y-%m-%d %H:%M:%S')
logger = logging.getLogger(__name__)


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--debug', required=False, action='store_true')
    parser.add_argument('--environment', required=False, default='production')
    parser.add_argument('--stations_from', required=False, default='')
    parser.add_argument('--stations_to', required=False, default='')
    parser.add_argument('--output_file', required=True)
    _args = vars(parser.parse_args())

    quality_tool = QualityTool(
        _args['environment'],
        _args['stations_from'],
        _args['stations_to'],
        '',  # use env var to specify pg password
        _args['debug'],
    )
    results = quality_tool.run()
    logger.info('Done with Quality tool.')

    with open(_args['output_file'], 'wb') as output_file:
        output_file.write(results)


if __name__ == '__main__':
    main()
