import argparse
import logging

from travel.avia.shared_flights.tasks.schedules_dumper.schedules_dumper import SchedulesDumper

logging.basicConfig(
    format='%(asctime)s %(levelname)-8s %(message)s',
    level=logging.DEBUG,
    datefmt='%Y-%m-%d %H:%M:%S')
logger = logging.getLogger(__name__)


# Sample run:
# bin/schedules-dumper --flight_date_from=2020-08-20 --flight_date_until=2020-08-21 --output_path=//home/avia/dev/u-jeen/dump_schedules --max_rows_per_select=200
def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--flight_date_from', required=True)
    parser.add_argument('--flight_date_until', required=True)
    parser.add_argument('--max_rows_per_select', required=False)
    parser.add_argument('--output_path', required=True)
    _args = vars(parser.parse_args())

    schedules_dumper = SchedulesDumper(
        _args['output_path'],
        '',  # use env var to specify OAuth token
        '',  # use env var to specify Postgres password
        _args['max_rows_per_select'],
    )
    results = schedules_dumper.run(
        _args['flight_date_from'],
        _args['flight_date_until'],
    )
    logger.info('Dumper results: %s.', results)
    logger.info('Done with schedules dumper.')


if __name__ == '__main__':
    main()
