# coding=utf-8
from __future__ import unicode_literals

import six

from travel.library.python.safexml.safe_xml_parser import safe_xml_fromstring
from travel.proto.shared_flights.sirena.airline_pb2 import TAirline


class AirlinesImporter:
    """ Parses an Sirena airline data into a python model """

    def parse(self, airline_file_contents):
        airlines = []

        for carrier_el in safe_xml_fromstring(six.ensure_binary(airline_file_contents)).xpath('//data'):
            sirena_code = ''
            iata_code = ''
            for code_el in carrier_el.findall('./code'):
                for name, value in code_el.items():
                    if name.endswith('lang'):
                        if value == 'ru':
                            sirena_code = code_el.text
                        elif value == 'en':
                            iata_code = code_el.text

            title_ru = ''
            title_en = ''
            for name_el in carrier_el.findall('./name'):
                for name, value in name_el.items():
                    if name.endswith('lang'):
                        if value == 'ru':
                            title_ru = name_el.text
                        elif value == 'en':
                            title_en = name_el.text

            account_code_el = carrier_el.find('./account-code')

            airline = TAirline()
            airline.SirenaCode = six.ensure_str(sirena_code)
            airline.IataCode = six.ensure_str(iata_code)
            airline.Title = six.ensure_str(title_ru)
            airline.TitleEn = six.ensure_str(title_en)
            if account_code_el is not None and account_code_el.text:
                airline.AccountCode = six.ensure_str(account_code_el.text)
            airlines.append(airline)

        return airlines
