import argparse
import logging

from travel.avia.shared_flights.tasks.sirena_parser.sirena_fetcher import SirenaFetcher

logging.basicConfig(
    format='%(asctime)s %(levelname)-8s %(message)s',
    level=logging.DEBUG,
    datefmt='%Y-%m-%d %H:%M:%S')
logger = logging.getLogger(__name__)


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--host', required=False)
    parser.add_argument('--port_name', required=True)
    parser.add_argument('--client_id', required=True)
    parser.add_argument('--carrier_codes', required=True)
    parser.add_argument('--output_file', required=True)
    parser.add_argument('--oauth_token', required=False)
    _args = vars(parser.parse_args())

    sirena_fetcher = SirenaFetcher(
        host=_args['host'],
        port_name=_args['port_name'],
        client_id=int(_args['client_id']),
        carrier_codes=_args['carrier_codes'],
        oauth_token=_args['oauth_token'],
    )
    zip_file, new_transport_models = sirena_fetcher.fetch()
    logger.info('Done with Sirena fetching.')

    with open('new_transport_models.txt', 'w') as models_file:
        for new_transport_model in new_transport_models:
            models_file.write('%s \n' % new_transport_model)

    with open(_args['output_file'], 'wb') as output_file:
        output_file.write(zip_file.getvalue())


if __name__ == '__main__':
    main()
