import travel.proto.shared_flights.ssim.aircraft_pb2 as aircraft_pb2


class AircraftImporter:
    """ Parses an Innovata aircraft file into a protobuf """

    def __init__(self, logger):
        self._logger = logger

    def parse(self, line):
        parts = line.replace('\r', '').split('\t')
        if not parts:
            return None

        if len(parts) != 6:
            self._logger.info('Skipped aircraft with not enough fields: {}'.format(line))
            return None

        aircraft = aircraft_pb2.TAircraft()
        aircraft.Model = parts[0]
        aircraft.SubModel = parts[1]
        aircraft.Title = parts[2]
        aircraft.AverageSpeed = int(parts[3]) if len(parts[3]) > 0 else 0
        aircraft.Type = parts[4]
        aircraft.IsWideBody = 'Y' in parts[5]

        return aircraft
