import argparse
import logging

from travel.avia.shared_flights.tasks.ssim_parser.ssim_fetcher import SsimFetcher

logging.basicConfig(
    format='%(asctime)s %(levelname)-8s %(message)s',
    level=logging.DEBUG,
    datefmt='%Y-%m-%d %H:%M:%S')
logger = logging.getLogger(__name__)


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--hostname', required=True)
    parser.add_argument('--username', required=True)
    parser.add_argument('--password', required=True)
    parser.add_argument('--last_parsed', required=True)
    parser.add_argument('--aircraft_only', required=False)
    parser.add_argument('--oauth_token', required=False)
    _args = vars(parser.parse_args())

    ssim_fetcher = SsimFetcher(
        hostname=_args['hostname'],
        username=_args['username'],
        password=_args['password'],
        logger=logger,
    )
    aircraft_only = True
    if _args.get('aircraft_only') is not None:
        aircraft_only = bool(_args.get('aircraft_only'))
    result = ssim_fetcher.fetch(_args['last_parsed'], aircraft_only, _args['oauth_token'])

    with open('new_transport_models.txt', 'w') as tmdiffs_file:
        for transport_model in result.new_transport_models:
            tmdiffs_file.write('New model: %s\n' % transport_model)
    logger.info('Transport model diffs file: transport_model_diffs.txt')

    logger.info('SSIM date: {}'.format(result.current_ssim_date))
    logger.info('Aircraft file: {}'.format(result.aircraft_output_file))
    logger.info('Flight bases file: {}'.format(result.flight_bases_file))
    logger.info('Flight patterns file: {}'.format(result.flight_patterns_file))
    logger.info('Designated carriers file: {}'.format(result.designated_carriers_file))
    logger.info('Flying carriers file: {}'.format(result.flying_carriers_file))
    logger.info('Done with SSIM fetching.')


if __name__ == '__main__':
    main()
