from __future__ import unicode_literals

import six

from collections import defaultdict

import travel.proto.shared_flights.ssim.flights_pb2 as flights_pb2


# Caches codeshare info from the ssim file.
# Assumption: codeshare info from Rec4/050 record worth more than from Rec4/010 record
class SsimCodesharesMap:

    def __init__(self):
        self.codeshares_050 = defaultdict(list)
        self.codeshares_010 = defaultdict(list)

    def add_codeshare_050(
        self,
        marketing_carrier_code,
        marketing_flight_number,
        marketing_leg_number,
        operating_carrier_code,
        operating_flight_number,
        operating_leg_number,
        from_date,
        until_date,
    ):
        self.codeshares_050[(
            marketing_carrier_code,
            marketing_flight_number,
            marketing_leg_number,
            operating_carrier_code,
            operating_flight_number,
            operating_leg_number,
        )].append((from_date, until_date))

    def add_codeshare_010(
        self,
        marketing_carrier_code,
        marketing_flight_number,
        marketing_leg_number,
        operating_carrier_code,
        operating_flight_number,
        operating_leg_number,
        from_date,
        until_date,
    ):
        self.codeshares_010[(
            marketing_carrier_code,
            marketing_flight_number,
            marketing_leg_number,
            operating_carrier_code,
            operating_flight_number,
            operating_leg_number,
        )].append((from_date, until_date))

    def protos(self):
        for key, value_list in six.iteritems(self.codeshares_050):
            value0 = value_list[0]
            min_from = value0[0]
            max_until = value0[1]
            for value in value_list:
                if value[0] < min_from:
                    min_from = value[0]
                if value[1] > max_until:
                    max_until = value[1]
            codeshare = flights_pb2.TSsimCodeshare()
            codeshare.MarketingCarrierCode = key[0]
            codeshare.MarketingFlightNumber = key[1]
            codeshare.MarketingLegNumber = key[2]
            codeshare.OperatingCarrierCode = key[3]
            codeshare.OperatingFlightNumber = key[4]
            codeshare.OperatingLegNumber = key[5]
            codeshare.FromDate = min_from
            codeshare.UntilDate = max_until
            codeshare.SourceField = "050"
            yield codeshare

        for key, value_list in six.iteritems(self.codeshares_010):
            value0 = value_list[0]
            min_from = value0[0]
            max_until = value0[1]
            for value in value_list:
                if value[0] < min_from:
                    min_from = value[0]
                if value[1] > max_until:
                    max_until = value[1]
            codeshare = flights_pb2.TSsimCodeshare()
            codeshare.MarketingCarrierCode = key[0]
            codeshare.MarketingFlightNumber = key[1]
            codeshare.MarketingLegNumber = key[2]
            codeshare.OperatingCarrierCode = key[3]
            codeshare.OperatingFlightNumber = key[4]
            codeshare.OperatingLegNumber = key[5]
            codeshare.FromDate = min_from
            codeshare.UntilDate = max_until
            codeshare.SourceField = "010"
            yield codeshare
