package app

import (
	"time"

	"a.yandex-team.ru/travel/avia/library/go/probes"
	httpserver "a.yandex-team.ru/travel/library/go/httputil/server"
	"a.yandex-team.ru/travel/library/go/logging"
	metricsserver "a.yandex-team.ru/travel/library/go/metrics/server"
)

type TvmConfig struct {
	Enabled       bool          `config:"TVM_ENABLED"`
	WhiteList     []uint32      `config:"TVM_WHITE_LIST" yaml:"tvmwhitelist"`
	CacheTTL      time.Duration `config:"TVM_CACHE_TTL" yaml:"cache-ttl"`
	CacheMaxItems int           `config:"TVM_CACHE_MAX_ITEMS" yaml:"cache-max-items"`
	SelfAppID     int           `yaml:"selfappid"`
}

type Config struct {
	EnvType string `config:"yenv-type,required"`
	HTTP    httpserver.HTTPConfig
	Metrics metricsserver.MetricsConfig
	Logging logging.Config
	Tvm     TvmConfig
	Sirena  SirenaConfig
	Probes  probes.HTTPConfig `yaml:"probes"`
}

type SirenaConfig struct {
	Host        string            `config:"host"`
	PortAlias   map[string]string `config:"port-alias"`
	ClientAlias map[string]uint16 `config:"client-alias"`
}

var DefaultTvmConfig = TvmConfig{
	Enabled:       true,
	WhiteList:     nil,
	CacheTTL:      time.Duration(5 * time.Minute),
	CacheMaxItems: 100,
}

var DefaultSirenaConfig = SirenaConfig{
	Host: "193.104.87.251",
	PortAlias: map[string]string{
		"study":      "34323",
		"test":       "34322",
		"production": "34321",
	},
	ClientAlias: map[string]uint16{
		"redwings": 2979,
	},
}

var Cfg = Config{
	EnvType: "development",
	HTTP:    httpserver.DefaultHTTPConfig,
	Metrics: metricsserver.DefaultMetricsConfig,
	Logging: logging.DefaultConfig,
	Tvm:     DefaultTvmConfig,
	Sirena:  DefaultSirenaConfig,
	Probes:  probes.DefaultHTTPConfig,
}
