# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

import os
import sys

os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'travel.avia.stat_admin.local_settings')


def gunicorn():
    from library.python.gunicorn import run_standalone
    from travel.avia.stat_admin import wsgi

    run_standalone(wsgi.application)


def manage():
    from django.core.management import execute_from_command_line

    print('Loading manage.py')
    execute_from_command_line(sys.argv)


def celery():
    sys.path.insert(0, '/etc/yandex/yandex-avia-stats')

    import django
    django.setup()

    from travel.avia.stat_admin.data.tasks import celery_app

    celery_app.start()
