# -*- coding: utf-8 -*-
from django.contrib import admin

from travel.avia.stat_admin.data.models import (
    UsersSearch, UserRedirect, PartnerQuery, UTM_ReportsHistory, Setting, OhmIncoming, OhmRedirect
)


class OhmIncomingAdmin(admin.ModelAdmin):
    list_display = ('version', 'eventdatetime', 'utm_title', 'yandexuid')
    list_filter = ('version', )
    ordering = ('-eventdate', )

    def utm_title(self, obj):
        return '{source}, {campaign}'.format(
            source=obj.utm.source,
            campaign=obj.utm.campaign,
        )

    utm_title.short_description = 'UTM'


admin.site.register(OhmIncoming, OhmIncomingAdmin)


class OhmRedirectAdmin(admin.ModelAdmin):
    list_display = ('version', 'eventdatetime', 'yandexuid')
    list_filter = ('version', )
    ordering = ('-eventdate', )

admin.site.register(OhmRedirect, OhmRedirectAdmin)


class SettingAdmin(admin.ModelAdmin):
    list_display = ('key', 'value')

admin.site.register(Setting, SettingAdmin)


class UsersSearchAdmin(admin.ModelAdmin):
    list_filter = ('service',)
    list_display = ('service', 'eventdate', 'count')

admin.site.register(UsersSearch, UsersSearchAdmin)


class UTM_ReportsHistoryAdmin(admin.ModelAdmin):
    list_display = ('report_date', 'yaml_file', 'success', 'last_error')

admin.site.register(UTM_ReportsHistory, UTM_ReportsHistoryAdmin)


class PartnerQueryAdmin(admin.ModelAdmin):
    list_filter = ('service', 'partner_code')
    list_display = ('service', 'query_datetime', 'query_status', 'partner_code', 'count')

admin.site.register(PartnerQuery, PartnerQueryAdmin)


class UserRedirectAdmin(admin.ModelAdmin):
    list_filter = ('service', 'partner_code')
    list_display = ('service', 'eventdate', 'partner_code', 'count')

admin.site.register(UserRedirect, UserRedirectAdmin)
