from collections import OrderedDict

from django import forms
from django.contrib.admin.widgets import AdminDateWidget
from django.utils.translation import ugettext as _
from rangefilter.filter import DateRangeFilter


class AviaDateRangeFilter(DateRangeFilter):
    def _get_form_fields(self):
        return OrderedDict((
            (self.lookup_kwarg_gte, forms.DateField(
                label='',
                widget=AdminDateWidget(attrs={'placeholder': _('From date'), 'type': 'date'}),
                localize=True,
                required=False
            )),
            (self.lookup_kwarg_lte, forms.DateField(
                label='',
                widget=AdminDateWidget(attrs={'placeholder': _('To date'), 'type': 'date'}),
                localize=True,
                required=False
            )),
        ))
