# -*- coding: utf-8 -*-
from django.contrib import admin

from travel.avia.stat_admin.data.models.partner import EmailType, PartnerCode, PartnerEmail


class PartnerEmailInline(admin.TabularInline):
    model = PartnerEmail


class EmailTypeAdmin(admin.ModelAdmin):
    list_display = ('code', 'title',)
    inlines = (PartnerEmailInline,)

admin.site.register(EmailType, EmailTypeAdmin)


class PartnerCodeAdmin(admin.ModelAdmin):
    list_display = ('code',)
    inlines = (PartnerEmailInline,)

admin.site.register(PartnerCode, PartnerCodeAdmin)


class PartnerEmailAdmin(admin.ModelAdmin):
    list_display = ('partner_code', 'emailtype', 'email',)

admin.site.register(PartnerEmail, PartnerEmailAdmin)
