import json
import logging
from functools import partial

from django.conf import settings
from django.http import JsonResponse
from django.views.decorators.csrf import csrf_exempt

from travel.avia.stat_admin.lib.basic_auth import basicauth
from travel.avia.stat_admin.lib.avia_importers import airport_importer

log = logging.getLogger(__name__)


@csrf_exempt
@partial(basicauth, settings.AVIA_IMPORT_USER_AUTH)
def import_avia_airports(request):
    try:
        info = airport_importer.import_models(json.loads(request.body))

        return JsonResponse({
            'status': 'ok',
            'data': info
        })
    except Exception as e:
        log.exception('import_avia_airport: %r', e)
        return JsonResponse({
            'status': 'error',
            'message': '{}'.format(e)
        })
