# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import models, migrations


class Migration(migrations.Migration):

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Error500',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('eventdate', models.DateField(db_index=True)),
                ('code', models.PositiveIntegerField(default=0)),
                ('min_eventtime', models.DateTimeField(null=True, blank=True)),
                ('max_eventtime', models.DateTimeField(null=True, blank=True)),
                ('count', models.PositiveIntegerField(default=0)),
                ('request', models.CharField(max_length=255)),
            ],
            options={
                'ordering': ['-eventdate', '-count', 'code'],
            },
        ),
        migrations.CreateModel(
            name='PartnerQuery',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('service', models.CharField(max_length=6, verbose_name='\u0421\u0435\u0440\u0432\u0438\u0441', choices=[(b'ticket', b'ticket'), (b'rasp', b'rasp')])),
                ('query_datetime', models.DateTimeField(verbose_name='\u0412\u0440\u0435\u043c\u044f')),
                ('query_status', models.CharField(max_length=128, verbose_name='\u0421\u0442\u0430\u0442\u0443\u0441 \u043e\u0442\u0432\u0435\u0442\u0430')),
                ('partner_code', models.CharField(max_length=128, verbose_name='\u0418\u043c\u043f\u043e\u0440\u0442\u0435\u0440')),
                ('count', models.PositiveIntegerField(verbose_name='\u041a\u043e\u043b-\u0432\u043e')),
            ],
            options={
                'verbose_name': '\u043e\u043f\u0440\u043e\u0441 \u043f\u0430\u0440\u043d\u0435\u0440\u0430',
                'verbose_name_plural': '\u043e\u043f\u0440\u043e\u0441\u044b \u043f\u0430\u0440\u043d\u0435\u0440\u043e\u0432',
            },
        ),
        migrations.CreateModel(
            name='RedirectHeatMap',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('eventdate', models.DateTimeField(null=True, verbose_name='\u0412\u0440\u0435\u043c\u044f', blank=True)),
                ('national_version', models.CharField(default=b'ru', max_length=2, null=True, verbose_name='\u041d\u0430\u0446. \u0432\u0435\u0440\u0441\u0438\u044f')),
                ('count', models.IntegerField(default=0, verbose_name='\u041a\u043e\u043b-\u0432\u043e')),
                ('geo_id', models.IntegerField(default=0, verbose_name='geo_id')),
                ('lon', models.FloatField(verbose_name='\u0414\u043e\u043b\u0433\u043e\u0442\u0430')),
                ('lat', models.FloatField(verbose_name='\u0428\u0438\u0440\u043e\u0442\u0430')),
                ('country', models.CharField(default=b'ru', max_length=128, null=True, verbose_name='\u0421\u0442\u0440\u0430\u043d\u0430')),
            ],
            options={
                'verbose_name': '\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u0438\u0439 \u043f\u0435\u0440\u0435\u0445\u043e\u0434',
                'verbose_name_plural': '\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u0438\u0435 \u043f\u0435\u0440\u0435\u0445\u043e\u0434\u044b',
            },
        ),
        migrations.CreateModel(
            name='ServiceMetric',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('service', models.CharField(max_length=6, verbose_name='\u0421\u0435\u0440\u0432\u0438\u0441', choices=[(b'ticket', b'ticket'), (b'rasp', b'rasp')])),
                ('event_datetime', models.DateTimeField(verbose_name='\u0412\u0440\u0435\u043c\u044f')),
                ('event_day', models.PositiveIntegerField(verbose_name='\u0414\u0435\u043d\u044c')),
                ('event_month', models.PositiveIntegerField(verbose_name='\u041c\u0435\u0441\u044f\u0446')),
                ('event_year', models.PositiveIntegerField(verbose_name='\u0413\u043e\u0434')),
                ('event_name', models.CharField(max_length=128, verbose_name='\u041c\u0435\u0442\u0440\u0438\u043a\u0430')),
                ('value', models.IntegerField(verbose_name='\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435')),
            ],
            options={
                'verbose_name': '\u043c\u0435\u0442\u0440\u0438\u043a\u0430',
                'verbose_name_plural': '\u043c\u0435\u0442\u0440\u0438\u043a\u0438',
            },
        ),
        migrations.CreateModel(
            name='UserRedirect',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('service', models.CharField(max_length=6, verbose_name='\u0421\u0435\u0440\u0432\u0438\u0441', choices=[(b'ticket', b'ticket'), (b'rasp', b'rasp')])),
                ('eventdate', models.DateTimeField(null=True, verbose_name='\u0412\u0440\u0435\u043c\u044f', blank=True)),
                ('count', models.IntegerField(default=0, verbose_name='\u041a\u043e\u043b-\u0432\u043e')),
                ('partner_code', models.CharField(max_length=32, verbose_name='\u041a\u043e\u0434 \u043f\u0430\u0440\u0442\u043d\u0435\u0440\u0430')),
                ('national_version', models.CharField(default=b'ru', max_length=2, null=True, verbose_name='\u041d\u0430\u0446. \u0432\u0435\u0440\u0441\u0438\u044f')),
            ],
            options={
                'verbose_name': '\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u0438\u0439 \u043f\u0435\u0440\u0435\u0445\u043e\u0434',
                'verbose_name_plural': '\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u0438\u0435 \u043f\u0435\u0440\u0435\u0445\u043e\u0434\u044b',
            },
        ),
        migrations.CreateModel(
            name='UsersSearch',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('service', models.CharField(max_length=6, verbose_name='\u0421\u0435\u0440\u0432\u0438\u0441', choices=[(b'ticket', b'ticket'), (b'rasp', b'rasp')])),
                ('eventdate', models.DateTimeField(null=True, verbose_name='\u0412\u0440\u0435\u043c\u044f', blank=True)),
                ('count', models.IntegerField(default=0, verbose_name='\u041a\u043e\u043b-\u0432\u043e')),
                ('national_version', models.CharField(default=b'ru', max_length=2, null=True, verbose_name='\u041d\u0430\u0446. \u0432\u0435\u0440\u0441\u0438\u044f')),
            ],
            options={
                'verbose_name': '\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u0438\u0439 \u043f\u043e\u0438\u0441\u043a',
                'verbose_name_plural': '\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u0438\u0435 \u043f\u043e\u0438\u0441\u043a\u0438',
            },
        ),
        migrations.CreateModel(
            name='YandexUID',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('service', models.CharField(max_length=6, verbose_name='\u0421\u0435\u0440\u0432\u0438\u0441', choices=[(b'ticket', b'ticket'), (b'rasp', b'rasp')])),
                ('eventdate', models.DateField(null=True, verbose_name='\u0412\u0440\u0435\u043c\u044f', blank=True)),
                ('count', models.IntegerField(default=0, verbose_name='\u041a\u043e\u043b-\u0432\u043e')),
                ('national_version', models.CharField(default=b'ru', max_length=2, null=True, verbose_name='\u041d\u0430\u0446. \u0432\u0435\u0440\u0441\u0438\u044f')),
            ],
            options={
                'verbose_name': 'yandexUID',
                'verbose_name_plural': 'yandexUIDs',
            },
        ),
        migrations.AlterUniqueTogether(
            name='yandexuid',
            unique_together=set([('service', 'eventdate', 'national_version')]),
        ),
        migrations.AlterUniqueTogether(
            name='userssearch',
            unique_together=set([('service', 'eventdate', 'national_version')]),
        ),
        migrations.AlterUniqueTogether(
            name='userredirect',
            unique_together=set([('national_version', 'service', 'eventdate', 'partner_code')]),
        ),
        migrations.AlterUniqueTogether(
            name='servicemetric',
            unique_together=set([('service', 'event_name', 'event_datetime')]),
        ),
        migrations.AlterIndexTogether(
            name='servicemetric',
            index_together=set([('service', 'event_name', 'event_year', 'event_month', 'event_day'), ('event_name', 'event_datetime')]),
        ),
        migrations.AlterUniqueTogether(
            name='redirectheatmap',
            unique_together=set([('national_version', 'eventdate', 'geo_id')]),
        ),
        migrations.AlterIndexTogether(
            name='partnerquery',
            index_together=set([('service', 'query_datetime', 'partner_code'), ('query_status',)]),
        ),
    ]
