# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import models, migrations


class Migration(migrations.Migration):

    dependencies = [
        ('data', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='UTM',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('source', models.CharField(max_length=255)),
                ('campaign', models.CharField(max_length=255)),
                ('medium', models.CharField(max_length=255)),
            ],
            options={
                'verbose_name': 'UTM \u043c\u0435\u0442\u043a\u0430',
                'verbose_name_plural': 'UTM \u043c\u0435\u0442\u043a\u0438',
            },
        ),
        migrations.CreateModel(
            name='UTM_incoming',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('eventdate', models.DateField(null=True, verbose_name='\u0414\u0430\u0442\u0430', blank=True)),
                ('yandexuid', models.CharField(max_length=32)),
                ('utm', models.ForeignKey(related_name='+', verbose_name='UTM', to='data.UTM')),
            ],
            options={
                'verbose_name': '\u0432\u0445\u043e\u0434\u044f\u0449\u0430\u044f utm',
                'verbose_name_plural': '\u0432\u0445\u043e\u0434\u044f\u0449\u0438\u0435 utm',
            },
        ),
        migrations.CreateModel(
            name='UTM_redirect',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('eventdate', models.DateField(null=True, verbose_name='\u0414\u0430\u0442\u0430', blank=True)),
                ('cohort', models.PositiveSmallIntegerField(verbose_name='UTM')),
                ('yandexuid', models.CharField(max_length=32)),
                ('utm', models.ForeignKey(related_name='+', verbose_name='UTM', to='data.UTM')),
            ],
            options={
                'verbose_name': '\u0438\u0441\u0445\u043e\u0434\u044f\u0449\u0430\u044f utm',
                'verbose_name_plural': '\u0438\u0441\u0445\u043e\u0434\u044f\u0449\u0438\u0435 utm',
            },
        ),
        migrations.AlterUniqueTogether(
            name='utm',
            unique_together=set([('source', 'campaign', 'medium')]),
        ),
        migrations.AlterIndexTogether(
            name='utm_redirect',
            index_together=set([('yandexuid',), ('eventdate', 'yandexuid')]),
        ),
        migrations.AlterIndexTogether(
            name='utm_incoming',
            index_together=set([('yandexuid',), ('eventdate', 'yandexuid')]),
        ),
    ]
