# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import models, migrations


class Migration(migrations.Migration):

    dependencies = [
        ('data', '0023_rivalposition_cheaper'),
    ]

    operations = [
        migrations.CreateModel(
            name='OhmAdwords',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('eventdate', models.DateField(verbose_name='\u0414\u0430\u0442\u0430', db_index=True)),
                ('cost', models.FloatField(default=0, verbose_name='\u0426\u0435\u043d\u0430 \u043a\u043b\u0438\u043a\u043e\u0432')),
                ('clicks', models.IntegerField(default=0, verbose_name='\u041a\u043e\u043b-\u0432\u043e \u043a\u043b\u0438\u043a\u043e\u0432')),
            ],
            options={
                'verbose_name': 'Ohm \u0434\u0430\u043d\u043d\u044b\u0435 adwords',
                'verbose_name_plural': 'Ohm \u0434\u0430\u043d\u043d\u044b\u0435 adwords',
            },
        ),
        migrations.CreateModel(
            name='OhmIncoming',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('eventdate', models.DateField(verbose_name='\u0414\u0430\u0442\u0430')),
                ('eventdatetime', models.DateTimeField(verbose_name='\u0414\u0430\u0442\u0430 \u0438 \u0432\u0440\u0435\u043c\u044f')),
                ('yandexuid', models.CharField(max_length=32)),
            ],
            options={
                'verbose_name': 'OHM \u0432\u0445\u043e\u0434\u044f\u0448\u0430\u044f UTM',
                'verbose_name_plural': 'OHM \u0432\u0445\u043e\u0434\u044f\u0449\u0438\u0435 UTM',
            },
        ),
        migrations.CreateModel(
            name='OhmRedirect',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('eventdate', models.DateField(verbose_name='\u0414\u0430\u0442\u0430')),
                ('eventdatetime', models.DateTimeField(verbose_name='\u0414\u0430\u0442\u0430 \u0438 \u0432\u0440\u0435\u043c\u044f')),
                ('yandexuid', models.CharField(max_length=32)),
            ],
            options={
                'verbose_name': 'OHM \u0440\u0435\u0434\u0438\u0440\u0435\u043a\u0442',
                'verbose_name_plural': 'OHM \u0440\u0435\u0434\u0438\u0440\u0435\u043a\u0442\u044b',
            },
        ),
        migrations.CreateModel(
            name='OhmUtm',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('source', models.CharField(max_length=255)),
                ('campaign', models.CharField(max_length=255)),
                ('medium', models.CharField(max_length=255)),
                ('term', models.CharField(max_length=255)),
            ],
            options={
                'verbose_name': 'OHM UTM \u043c\u0435\u0442\u043a\u0430',
                'verbose_name_plural': 'OHM UTM \u043c\u0435\u0442\u043a\u0438',
            },
        ),
        migrations.AlterUniqueTogether(
            name='ohmutm',
            unique_together=set([('source', 'campaign', 'medium', 'term')]),
        ),
        migrations.AlterIndexTogether(
            name='ohmredirect',
            index_together=set([('yandexuid',), ('eventdate', 'yandexuid')]),
        ),
        migrations.AddField(
            model_name='ohmincoming',
            name='utm',
            field=models.ForeignKey(related_name='+', verbose_name='UTM', to='data.OhmUtm'),
        ),
        migrations.AddField(
            model_name='ohmadwords',
            name='utm',
            field=models.ForeignKey(related_name='+', verbose_name='UTM', to='data.OhmUtm'),
        ),
        migrations.AlterIndexTogether(
            name='ohmincoming',
            index_together=set([('yandexuid',), ('eventdate', 'yandexuid')]),
        ),
        migrations.AlterIndexTogether(
            name='ohmadwords',
            index_together=set([('eventdate', 'utm')]),
        ),
    ]
