# -*- coding: utf-8 -*-
from django.db import models


class PartnerCode(models.Model):
    code = models.CharField(
        verbose_name=u'Код парнера', max_length=32, null=False, blank=False,
        unique=True,
    )

    class Meta:
        app_label = 'data'

    def __unicode__(self):
        return u'{}'.format(self.code)


class EmailType(models.Model):
    code = models.CharField(
        verbose_name=u'Код', max_length=24, null=False, blank=False,
        unique=True,
    )

    title = models.CharField(
        verbose_name=u'Тип емейла',
        null=False, blank=True, default='', max_length=64
    )

    class Meta:
        app_label = 'data'

    def __unicode__(self):
        return u'{}'.format(self.title or self.code)


class PartnerEmail(models.Model):
    partner_code = models.ForeignKey(PartnerCode, related_name='emails')
    emailtype = models.ForeignKey(EmailType, related_name='emails')
    email = models.CharField(blank=False, null=False, max_length=64)

    class Meta:
        app_label = 'data'
        ordering = ['partner_code', 'emailtype', 'email']

    def __unicode__(self):
        return u'{} {} {}'.format(self.partner_code, self.emailtype, self.email)
