# -*- encoding: utf-8 -*-
# Django settings for avia_stats project.
import os

from travel.avia.stat_admin.settings.environment import EnvironmentType, YANDEX_ENVIRONMENT_TYPE

DEBUG = False
TEMPLATE_DEBUG = DEBUG

ADMINS = (
    # ('Your Name', 'your_email@example.com'),
)

MANAGERS = ADMINS

DATABASES = {
    'default': {
        'ENGINE': 'travel.avia.stat_admin.utils.mysql_switcher',
    }
}

# Local time zone for this installation. Choices can be found here:
# http://en.wikipedia.org/wiki/List_of_tz_zones_by_name
# although not all choices may be available on all operating systems.
# In a Windows environment this must be set to your system time zone.
TIME_ZONE = 'Europe/Moscow'

# Language code for this installation. All choices can be found here:
# http://www.i18nguy.com/unicode/language-identifiers.html
LANGUAGE_CODE = 'ru-RU'

SITE_ID = 1

# If you set this to False, Django will make some optimizations so as not
# to load the internationalization machinery.
USE_I18N = False

# If you set this to False, Django will not format dates, numbers and
# calendars according to the current locale.
USE_L10N = True

# If you set this to False, Django will not use timezone-aware datetimes.
USE_TZ = True

# Absolute filesystem path to the directory that will hold user-uploaded files.
# Example: "/home/media/media.lawrence.com/media/"
MEDIA_ROOT = ''

# URL that handles the media served from MEDIA_ROOT. Make sure to use a
# trailing slash.
# Examples: "http://media.lawrence.com/media/", "http://example.com/media/"
MEDIA_URL = ''

# Absolute path to the directory media files should be collected to.
# Don't put anything in this directory yourself; store your media files
# in apps' "media/" subdirectories and in STATICFILES_DIRS.
# Example: "/home/media/media.lawrence.com/media/"
STATIC_ROOT = '/app/static/'
if YANDEX_ENVIRONMENT_TYPE == EnvironmentType.DEVELOPMENT and os.getenv('ENABLE_DEV_STATIC'):
    STATIC_ROOT = os.getenv('STATIC_ROOT')

# URL prefix for media files.
# Example: "http://media.lawrence.com/media/"
STATIC_URL = '/static/'

# Additional locations of media files
STATICFILES_DIRS = (
    # Put strings here, like "/home/html/media" or "C:/www/django/media".
    # Always use forward slashes, even on Windows.
    # Don't forget to use absolute paths, not relative paths.
)

# List of finder classes that know how to find media files in
# various locations.
STATICFILES_FINDERS = [
    'django.contrib.staticfiles.finders.FileSystemFinder',
    'django.contrib.staticfiles.finders.AppDirectoriesFinder',
]

# Make this unique, and don't share it with anybody.
SECRET_KEY = 'br04*ti&amp;ur*r0mxp-xb*qd2t2x9zf%#o69s1dbn%bpc$_)64^5'


INSTALLED_APPS = (
    'bootstrap3',
    'datetimewidget',
    'travel.avia.stat_admin.data',
    'travel.avia.stat_admin.job',
    'travel.avia.stat_admin.utils',
    'travel.avia.stat_admin.scripts',
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.humanize',
    'django.contrib.sessions',
    'django.contrib.sites',
    'django.contrib.messages',
    'django.contrib.staticfiles',
    'rangefilter',
    'django.contrib.admin',
    'django_idm_api',
    'rest_framework',
    'raven.contrib.django.raven_compat',
)

_AUTH_MIDDLEWARE_CLASSES = (
    'travel.avia.stat_admin.middleware.auth.Auth',
    'django_idm_api.middleware.TVMMiddleware',
)
if YANDEX_ENVIRONMENT_TYPE == EnvironmentType.DEVELOPMENT and os.getenv('DISABLE_AUTH_MIDDLEWARE'):
    _AUTH_MIDDLEWARE_CLASSES = ()

MIDDLEWARE_CLASSES = (
    'django.middleware.common.CommonMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
) + _AUTH_MIDDLEWARE_CLASSES + (
    'django.middleware.locale.LocaleMiddleware',
)

ROOT_URLCONF = 'travel.avia.stat_admin.urls'

# Python dotted path to the WSGI application used by Django's runserver.
WSGI_APPLICATION = 'travel.avia.stat_admin.wsgi.application'

from os.path import abspath, normpath, join, dirname
PROJECT_PATH = abspath(normpath(join(dirname(join(__file__)), '..')))

TEMPLATES = [
    {
        'BACKEND': 'django.template.backends.django.DjangoTemplates',
        'DIRS': ['travel/avia/stat_admin/data/templates'],
        'APP_DIRS': False,
        'OPTIONS': {
            'context_processors': [
                'django.template.context_processors.request',
                'django.contrib.auth.context_processors.auth',
                'django.contrib.messages.context_processors.messages',
            ],
        },
    },
]


# A sample logging configuration. The only tangible logging
# performed by this configuration is to send an email to
# the site admins on every HTTP 500 error when DEBUG=False.
# See http://docs.djangoproject.com/en/dev/topics/logging for
# more details on how to customize your logging configuration.
def create_logging(log_path, use_sentry=False):
    return {
    'version': 1,
    'disable_existing_loggers': False,
    'root': {
        'level': 'INFO',
        'handlers': ['tree', 'error', 'traceback'] + (['sentry'] if use_sentry else []),
    },
    'filters': {
        'require_debug_false': {
            '()': 'django.utils.log.RequireDebugFalse'
        }
    },
    'formatters': {
        'verbose': {
            'format': '%(levelname)s %(asctime)s: %(message)s'
        },
        'simple': {
            'format': '%(message)s'
        },
        'error': {
            '()': 'ylog.ExceptionFormatter',
            'format': '%(levelname)s %(asctime)s %(process)d %(pathname)s:%(funcName)s:%(lineno)d %(message)s',
        },
        'traceback': {
            '()': 'ylog.ExceptionFormatter',
            'format': '%(levelname)s %(asctime)s %(process)d %(pathname)s:%(funcName)s:%(lineno)d %(message)s',
            'full': True,
            'show_locals': True
        },
    },
    'handlers': {
        'sentry': {
            'level': 'ERROR',
            'class': 'raven.contrib.django.raven_compat.handlers.SentryHandler',
        },
        'mail_admins': {
            'level': 'ERROR',
            'filters': ['require_debug_false'],
            'class': 'django.utils.log.AdminEmailHandler'
        },
        'error': {
            'class': 'travel.avia.stat_admin.utils.logs.WatchedFileHandler',
            'filename': os.path.join(log_path, 'error.log'),
            'formatter': 'error',
            'level': 'ERROR',
        },
        'traceback': {
            'class': 'travel.avia.stat_admin.utils.logs.WatchedFileHandler',
            'filename': os.path.join(log_path, 'traceback.log'),
            'formatter': 'traceback',
            'level': 'ERROR',
        },
        'tree': {
            'level': 'DEBUG',
            'class': 'travel.avia.stat_admin.utils.logs.ArcadiaFileTreeHandler',
            'base_path': os.path.join(log_path, 'main'),
            'formatter': 'verbose',
            'remove_prefix': 'travel.avia.stat_admin',
        },
        'simple_tree': {
            'level': 'DEBUG',
            'class': 'travel.avia.stat_admin.utils.logs.ArcadiaFileTreeHandler',
            'base_path': os.path.join(log_path, 'main'),
            'formatter': 'simple',
            'remove_prefix': 'travel.avia.stat_admin',
        },
    },
    'loggers': {
        'django.request': {
            'handlers': ['mail_admins'],
            'level': 'ERROR',
            'propagate': True,
        },
        'error': {
            'handlers': ['error'],
            'level': 'ERROR',
        },
        'traceback': {
            'handlers': ['traceback'],
            'level': 'ERROR',
        },
        'yt.partner_review': {
            'handlers': ['simple_tree'],
            'level': 'INFO',
            'propagate': False,
        }
    }
}


PROJECT_PATH = os.path.abspath(os.path.join(os.path.dirname(__file__), '..'))
LOG_PATH = os.getenv('LOG_PATH', '/var/log/yandex-avia-stats')
LOG_FORMAT = u"%(filename)s %(levelname)s %(asctime)s: %(message)s Line: %(lineno)d"
LOGGING = create_logging(LOG_PATH, True)


# Нужно для работы is_secure, т.к. django стоит за проксей
SECURE_PROXY_SSL_HEADER = ('HTTP_X_FORWARDED_PROTOCOL', 'https')

AUTH_EXCLUDE_PATHS = tuple([
    u'/dostup/',
    u'/ping',
    u'/need_approve/',
    u'/rest/',
    u'/cohorts/',
    u'/import',
])


def get_env(variable_name, default=None, required=True):
    value = os.getenv(variable_name, default)
    if required:
        assert value is not None and value != default, 'empty %s env variable' % variable_name
    return value

# MDS
MDS_S3_REVISE_SCREENSHOTS_BUCKET = get_env('MDS_S3_REVISE_SCREENSHOTS_BUCKET')
MDS_S3_ENDPOINT_URL = get_env('MDS_S3_ENDPOINT_URL')
get_env('AWS_ACCESS_KEY_ID')
get_env('AWS_SECRET_ACCESS_KEY')

# Celery
CELERY_USER = os.getenv('CELERY_USER')
CELERY_PASSWORD= os.getenv('CELERY_PASSWORD')
BROKER_URL = 'amqp://{}:{}@localhost:5672//'.format(CELERY_USER, CELERY_PASSWORD)
CELERY_ACCEPT_CONTENT = ['pickle']
CELERY_TASK_SERIALIZER = 'pickle'
# Management: http://www.rabbitmq.com/management.html
# http://docs.celeryproject.org/en/latest/userguide/routing.html#manual-routing
CELERY_DEFAULT_QUEUE = 'avia_celery_default_queue'
CELERY_DEFAULT_EXCHANGE = 'avia_celery'
CELERY_DEFAULT_EXCHANGE_TYPE = 'direct'
CELERY_DEFAULT_ROUTING_KEY = 'task.default'
CELERYD_HIJACK_ROOT_LOGGER = False
CELERY_ROUTES = {
    'data.tasks.top_positions_task': {'queue': 'offline_jobs'},
}

AVIA_ADMIN_HOST = 'admin.avia.yandex-team.ru'

AVIA_NATIONAL_VERSIONS = ['ru', 'ua', 'tr', 'com', 'kz']
AVIA_NATIONAL_VERSIONS_CHOICES = tuple([(v, v) for v in AVIA_NATIONAL_VERSIONS])
AVIA_NATIONAL_VERSIONS_CHOICES_MAX_LEN = 5  # Изменять только вместе с миграцией!

if max(len(v) for v in AVIA_NATIONAL_VERSIONS) > AVIA_NATIONAL_VERSIONS_CHOICES_MAX_LEN:
    message = 'Len of one of national version is bigger AVIA_NATIONAL_VERSIONS_CHOICES_MAX_LEN={max_len}'.format(
        max_len=AVIA_NATIONAL_VERSIONS_CHOICES_MAX_LEN
    )
    raise ValueError(message)


YT_PROXY = os.getenv('YT_PROXY', 'hahn.yt.yandex.net')
YT_DATA_SIZE_PER_JOB = 128 * 1024 * 1024

ENABLE_DEBUG_CACHE = False
SEND_PARTNER_STAT_EMAIL_BCC = None
RASP_REST_HOST = None

GOOGLEADS_PATHS = [
    "/etc/yandex/yandex-avia-stats/googleads-310-345-5120.yaml",
    "/etc/yandex/yandex-avia-stats/googleads-908-789-4980.yaml",
]

AVIA_CLICK_PRICE = 19  # без НДС

ALLOW_GEOBASE = True
